# Changelog

## udocker (1.3.13)

* Mode Fn glibc fix dladdr(), dlopen(), dlmopen(), dl_iterate_phdr()
* Mode Fn glibc add dladdr1()
* Mode Fn glibc add execvpe(), execveat()
* Mode Fn glibc add getauxval()
* Mode Fn glibc add scandirat(), scandirat64()
* Mode Fn glibc change stat64(), lstat64(), stat()
* Mode Fn glibc add narrowing of program_invocation_name
* Mode Fn glibc improve command substitution
* Mode Fn musl fix dladdr(), dlopen(), dlmopen(), dl_iterate_phdr()
* Mode Fn musl execvpe()
* Mode Fn musl improve command substitution
* Mode Pn make links2symlinks feature disabled by default
* udocker improve is_binary_executable()
* udocker fix fakechroot parsing of so, exec_path and add cmd subst
* pylint compliance improvements
* use udockertools 1.2.11

## udocker (1.3.12)

* fix units tests, no modifications w.r.t. 1.3.11

## udocker (1.3.11)

* add support for hard link to symbolic link conversion in Pn modes
  as hard links cannot be created by unprivileged users - partially
  addresses: #388
* check of availability of network extensions for port mapping and
  netcoop in Pn modes and only use them if supported by the proot
  engine being invoked.
* improve image metadata generated by udocker on import - closes: #398

## udocker (1.3.10)

* improved handling of container platform information
* added support for QEMU on Pn modes enabling execution of containers
  with architectures different than the host
* selection of executable for Sn mode now defaults to apptainer and
  in second place to singularity
* the new command `manifest inspect` allows display of image manifests
  therefore enabling access to the catalogue of platforms supported by
  a given image
* the new command `tag` enables changing the name of an existing image
* new option `pull --platform=os/architecture` enables pulling of images
  of a given architecture possibly different from the host
* new option `run --platform=os/architecture` enables pull and run of
  images of a given architecture possibly different from the host
* new option `import --platform=os/architecture` enables to specify
  an architecture for the image
* new option `ps -p` enables list of the architectures of containers
* new option `images -p` enables list of the architectures of containers
* build udockertools 1.2.10 and set it as default
* the udockertools support for Fn now includes Ubuntu 23:04, Fedora 38,
  Alpine 3.17 and 3.18.
* experimental support for native Fn execution on arm64 for Fedora 36,
  Fedora 37, Fedora 38, CentOS 7, AlmaLinux 8, AlmaLinux 9 and Ubuntu 22,
  Ubuntu 20, Ubuntu 18 and similar.
* experimental support for native Fn execution on ppc64le for CentOS 7,
  AlmaLinux 8, AlmaLinux 9, Ubuntu 22, Ubuntu 20, Ubuntu 18 and similar.
* experimental support for runc in arm64 and ppc64le
* updated version of Pn engines for x86, x86_64, arm64.

## udocker (1.3.9)

* add support to access non-config metadata from containers
* added support for multiplatform manifests and indices solves #392 and #355

## udocker (1.3.8)

* build udockertools 1.2.9 and set it as default
* add Fn support for Ubuntu:22
* remove files to be installed
* set Fn preference to use runc

## udocker (1.3.7)

* Remove deprecated unit tests. udocker is the same as version 1.3.6

## udocker (1.3.6)

* re-implement udocker namespace solves #380
* login fails all the time solves #379
* Ignore image loading if already exists solves #378

## udocker (1.3.5)

* fix python backwards compatibility issues - closes: #374
* fix incorrectly reported errors by image verification
* fix image search returning empty results
* fix issue with logical links in the udocker executable path
* add check to verify if container name exists before creation
  or cloning
* add --force option to create and clone to allow creation
  of container even if the intended name given by --name exists
* prevent closing of file descriptors upon engine invocation
  improves PMI process management interface interoperability
* fix issues in import and export while using pipes.
* fix image name parsing where "library" component is missing - closes: #359

## udocker (1.3.4)

* fix 2 unit tests

## udocker (1.3.3)

* image list does not truncate long names - solve #349
* fix conditional warning in verify image
* fix and improve udocker high level tests

## udocker (1.3.2)

* fix missing f (format) for string
* fix bugs with dict .items()
* solving several pylint issues
* remove use2to3, fix issue #358

## udocker (1.3.1)

* Add --entrypoint to run --help
* Set docker hub registry registry-1.docker.io
* Fix repository name in search --list-tags
* Improve tests: udocker_test.sh and udocker_test-run.sh
* Documentation revision and improvements
* Add licenses and licenses notice to documentation
* Add test instructions
* Issues with --allow-root in Python 3.8
* Add security policy SECURITY.md
* Remove old Python 2 tests
* Fix configuration hierarchy, configuration files
* Update documentation: README, user and install manuals
* Fix sqa and config

## udocker (1.3.0)

* Prepare to move the stable code for Python 3 and Python 2 >= 2.6 to master
* Installation procedure changed since 1.1.x series see the `installation_manual`
* Improve user and installation documentation
* Extract documentation upon installation
* Add codemeta.json, metadata for the software
* Add support for `faccessat2()` in Pn and Fn execution modes
* Fix support for `newfstatat()` in Pn execution modes
* Add Fn libraries for Fedora 34 and Ubuntu 21.04
* Remove broken links in FileUtil.remove()
* update minimum udocker tools tarball to 1.2.8
* Cmd and entrypoint metadata and arguments processing changed to mimic docker
* Improve removal of files and links in install and filebind restore
* Add follow location option to GetURL()
* Implement use of `--entrypoint=<cmd>` to force execution of command - closes: #306
* Implement use of `--entrypoint=""` to bypass entrypoint in metadata - closes: #306

## udocker (1.2.9)

* method Unshare.unshare os.strerror() takes one argument - closes: #254
* Add unit test for #254
* Method chown udocker.utils.fileutil FileUtil - closes: #276
* Several fixes of unit tests and pylint
* Fix confusion between exit code 0 and inferred False
* Dereference on `safe_prefixes`
* untar exclude dev
* Fix rmi for referenced layers
* Set default for `PROOT_TMP_DIR`
* sysdir mountpoint not found and set tmpdir
* Update installation instructions
* Improve `oskernel_isgreater()`
* Improve `osinfo()`
* Fix repository login/logout
* Improve keystore logic
* Fix pull /v2

## udocker (1.2.8b2)

* Fix Rn modes to enable containers execution from readonly dirs
* Documentation centralized installation and readonly setups
* Fix handling of dockerhub repository names in /v2
* Improve documentation and algn with 1.1.8b2
* Add credits
* Fix delete of paths with symlinks - closes: #267, #265
* Fix issues with login credentials - closes: #310
* Fix pull images from docker hub in Termux - closes: #307
* Fix issues on running udocker in googlecolab - closes: #286
* Fix execution with Pn modes in alternate /tmp - closes: #284
* Add conditional delay-directory-restore to untar layers
* Add exclude of whiteouts on layer untar
* Add --nobanner to udocker run

## udocker (1.2.7)

* Major restructuring of the code
* Major restructuring of the unit tests
* Porting to Python 3, still supports python 2.7
* all fixes up to previous 1.1.7 version have been applied
* added scripts tests udocker: `utils/udocker_test.sh utils/udocker_test-run.sh`

## udocker (1.1.7)

* Fix P1 when Linux 4.8.0 SECCOMP is backported, affects newer CentOS 7 - closes: #282
* Check for file ownership on remove wrongly follows symlinks - closes: #266, #267
* udocker unexpectedly uses P1 exec mode instead of P2 - closes: #274
* Allow passing of `PROOT_TMP_DIR` environment variable - closes: #284

## udocker (1.1.6)

* Complete fix for of ELF paths in modes Fn for $ORIGIN:$ORIGIN - closes: #255

## udocker (1.1.5)

* Preliminary fix for of ELF paths in modes Fn for $ORIGIN:$ORIGIN
* Add Fn libraries for Ubuntu20, Fedora32, Fedora33
* Add Fn libraries for Alpine 3.12, 3.13

## udocker (1.1.4-1)

* Fix run --location
* Fix udocker integrated help
* Fix naming of containers
* Improve parsing of image names
* Documentation improvements
* `os._exit` from Unshare.unshare()
* Disable `FAKECHROOT_DISALLOW_ENV_CHANGES` in F4 mode

## udocker (1.1.4)

* Use hub.docker.com as default registry
* Search using v1 and v2 APIs
* Implement API /v2/search/repositories
* Adjust search results to screen size
* List container size with ps -s
* List container execution modes with ps -m
* Added support for nameat() and statx() in Pn and Fn modes
* Added Fn libraries for Ubuntu18, Ubuntu19, Fedora29, Fedora30, Fedora31, CentOS8
* Added Fn libraries for Alpine 3.8, 3.9, 3.10, 3.11
* Added support for sha512 hashes
* Added support for opaque whiteouts
* Added search --list-tags to available tags for a given repository
* Add CLI support for image names in format host/repository:tag
* Support for fake root in Sn execution modes via --user=root
* Improve verify of loaded/pulled images
* Improve handling of mountpoints
* Added --containerauth to enable direct use of the container passwd and group
* Added support for file mount bindings in singularity
* Added `UDOCKER_USE_PROOT_EXECUTABLE` env var to select proot location
* Added `UDOCKER_USE_RUNC_EXECUTABLE` env var to select runc location
* Added `UDOCKER_USE_SINGULARITY_EXECUTABLE` env var to select singularity
* Added `UDOCKER_DEFAULT_EXECUTION_MODE` env var to select default execution mode
* Added R2 and R3 execution modes for PRoot overlay execution in runc
* Added setup --purge for cleanup of mountpoints and files
* Added setup --fixperms to fix container file permissions
* Added run --env-file= to load file with environment variables
* Improve file and directory binding support for Singularity and runc
* Add command rename for renaming of containers
* Create processes without shell context
* Safer parsing of config files and removal of directories
* Improve installation
* Improved fix of SECCOMP accelerated mode for P1 mode
* Added loading and handling of container images in OCI format
* Fixes for udocker in ARM aarch64
* Fix processing of --dri in Sn mode - closes: #241
* Improve handling of container and host authentication - partially addresses: #239
* Fixes to address authentication and redirects in pull - closes: #225, #230
* Added minimal support to load OCI images - closes: #111
* Added Pn support for newer distributions - closes: #192
* Improve the installation of udockertools - closes: #220, #228
* Read environment variables from file with --env-file= - closes: #212
* Prepare for pypy - closes: #211
* Fixes for verification of container images - closes: #209
* Fix command line processing for "-" in argument - closes: #202
* Fix file protections on extraction making files u+r - closes: #202, #206
* Fix comparison of kernel versions having non-integers - closes: #183
* Support for both manifest V2 schema 1 and schema 2 - closes: #218, #225
* Further improved pathname translation in Fn modes - closes: #160
* Implement save images in docker format - closes: #74
* useradd and groupadd not working in containers - closes: #141
* fix return code when exporting to stdin - closes: #202

## udocker (1.1.3)

* Support for nvidia drivers on ubuntu - closes: #162
* Installation improvements - closes: #166
* Fix issue on Fn mode symlink conversion - partially addresses: #160

## udocker (1.1.2)

* Improve parsing of quotes in the command line - closes: #98
* Fix version command to exit with 0 - closes: #107
* Add kill-on-exit to proot on Pn modes
* Improve download of udocker utils
* Handle authentication headers when pulling - closes: #110
* Handle of redirects when pulling
* Fix registries table
* Support search quay.io
* Fix auth header when no standard Docker registry is used
* Add registry detection on image name
* Add --version option
* Force python2 as interpreter - closes: #131
* Fix handling of volumes in metadata
* Handle empty metadata
* Fix http proxy functionality - closes: #115
* Ignore --no-trunc and --all in the images command - closes: #108
* Implement verification of layers in manifest
* Add --nvidia to support GPUs and related drivers
* Send download messages to stderr
* Enable override of curl executable
* Fix building on CentOS 6 - closes: #157
* Mitigation for upstream limitation in runC without tty - closes: #132
* Fix detection of executable with symlinks in container - closes: #118
* Updated runC to v1.0.0-rc5
* Experimental support for Alpine in Fn modes
* Improve pathname translation in Fn modes for mounted dirs - partially addresses: #160

## udocker (1.1.1)

* New execution engine using singularity
* Updated documentation with OpenMPI information and examples
* Additional unit tests
* Redirect messages to stderr
* Improved parsing of quotes in the command line - closes: #87
* Allow override of the HOME environment variable
* Allow override of libfakechroot.so at the container level
* Automatic selection of libfakechroot.so from container info
* Improve automatic install
* Enable resetting prefix paths in Fn modes in remote hosts
* Do not set `AF_UNIX_PATH` in Fn modes when the host /tmp is a volume
* Export containers in both docker and udocker format
* Import containers docker and udocker format
* Load, import and export to/from stdin/stdout
* Clone existing containers
* Support for TCP/IP port remap in execution modes Pn
* Fix run with basenames failing - closes: #89
* Allow run as root flag - closes: #91

## udocker (1.1.0)

* Support image names prefixed by registry similarly to docker
* Add execution engine selection logic
* Add fr execution engine based on shared library interception
* Add rc execution engine based on rootless namespaces
* Improve proot tmp files cleanup on non ext filesystems
* Improve search returning empty on Docker repositories
* Improve runC execution portability
* Add environment variable `UDOCKER_KEYSTORE` - closes: #75
* Prevent creation of .udocker when `UDOCKER_KEYSTORE` is used - closes: #75

## udocker (1.0.4)

* Documentation fixes

## udocker (1.0.3)

* Support for import Docker containers in newer metadata structure
* Improve the command line parsing
* Improve temporary file handling and removal
* Support for additional execution engines to be provided in the future
* Improved parsing of entrypoint and cmd metadata - closes: #53
* Increase name alias length - closes: #52
* Add support for change dir into volume directories - closes: #51
* Fix deletion of files upon container import - closes: #50
* Fix exporting of host environment variables to the containers - closes: #48
* Change misleading behavior of import tarball from move to copy - closes: #44
* Fix validation of volumes specification - closes: #43

## udocker (1.0.2)

* Improve download on repositories that fail authentication on /v2
* Improve run verification of binaries with recursive symbolic links
* Improve accelerated seccomp on kernels >= 4.8.0 - closes: #40

## udocker (1.0.1)

* Minor bugfixes
* Executable name changed from udocker.py to udocker
* Added support for login into docker repositories
* Added support for private repositories
* Added support for listing of v2 repositories catalog
* Added checksum verification for sha256 layers
* Improved download handling for v1 and v2 repositories
* Improved installation tarball structure
* Insecure flag fixed
* Address seccomp change introduced on kernels >= 4.8.0
* Utilities for packaging
* Improved verbose levels, messaging and output - closes: #24, #23
* Fully implement support for registry selection --registry parameter - closes: #29
* Provide support for private repositories e.g. gitlab registries - closes: #30
* Provide --insecure command line parameter for SSL requests - closes: #31

## udocker (1.0.0)

* Initial version
